/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.impl.DirectTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.FileSystemTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.TimelineConnector;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TimelineClientImpl
extends TimelineClient {
    private static final Log LOG = LogFactory.getLog(TimelineClientImpl.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String RESOURCE_URI_STR_V1 = "/ws/v1/timeline/";
    private static Options opts = new Options();
    private static final String ENTITY_DATA_TYPE = "entity";
    private static final String DOMAIN_DATA_TYPE = "domain";
    @VisibleForTesting
    protected DelegationTokenAuthenticatedURL.Token token;
    @VisibleForTesting
    protected UserGroupInformation authUgi;
    @VisibleForTesting
    protected String doAsUser;
    private boolean timelineServiceV15Enabled;
    private TimelineWriter timelineWriter;
    private String timelineServiceAddress;
    @InterfaceAudience.Private
    @VisibleForTesting
    TimelineConnector connector;

    public TimelineClientImpl() {
        super(TimelineClientImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (!YarnConfiguration.timelineServiceV1Enabled((Configuration)conf)) {
            throw new IOException("Timeline V1 client is not properly configured. Either timeline service is not enabled or version is not set to 1.x");
        }
        this.timelineServiceV15Enabled = YarnConfiguration.timelineServiceV15Enabled((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUgi = ugi.getRealUser();
        if (realUgi != null) {
            this.authUgi = realUgi;
            this.doAsUser = ugi.getShortUserName();
        } else {
            this.authUgi = ugi;
            this.doAsUser = null;
        }
        this.token = new DelegationTokenAuthenticatedURL.Token();
        this.connector = this.createTimelineConnector();
        this.timelineServiceAddress = YarnConfiguration.useHttps((Configuration)conf) ? conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190") : conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188");
        LOG.info((Object)("Timeline service address: " + this.getTimelineServiceAddress()));
        super.serviceInit(conf);
    }

    @VisibleForTesting
    protected TimelineConnector createTimelineConnector() {
        TimelineConnector newConnector = new TimelineConnector(true, this.authUgi, this.doAsUser, this.token);
        this.addIfService((Object)newConnector);
        return newConnector;
    }

    protected void serviceStart() throws Exception {
        this.timelineWriter = this.createTimelineWriter(this.getConfig(), this.authUgi, this.connector.getClient(), TimelineConnector.constructResURI(this.getConfig(), this.timelineServiceAddress, RESOURCE_URI_STR_V1));
    }

    protected TimelineWriter createTimelineWriter(Configuration conf, UserGroupInformation ugi, Client webClient, URI uri) throws IOException {
        if (this.timelineServiceV15Enabled) {
            return new FileSystemTimelineWriter(conf, ugi, webClient, uri);
        }
        return new DirectTimelineWriter(ugi, webClient, uri);
    }

    protected void serviceStop() throws Exception {
        if (this.timelineWriter != null) {
            this.timelineWriter.close();
        }
        super.serviceStop();
    }

    @Override
    public void flush() throws IOException {
        if (this.timelineWriter != null) {
            this.timelineWriter.flush();
        }
    }

    @Override
    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        return this.timelineWriter.putEntities(entities);
    }

    @Override
    public void putDomain(TimelineDomain domain) throws IOException, YarnException {
        this.timelineWriter.putDomain(domain);
    }

    private String getTimelineServiceAddress() {
        return this.timelineServiceAddress;
    }

    @Override
    public Token<TimelineDelegationTokenIdentifier> getDelegationToken(final String renewer) throws IOException, YarnException {
        PrivilegedExceptionAction<Token<TimelineDelegationTokenIdentifier>> getDTAction = new PrivilegedExceptionAction<Token<TimelineDelegationTokenIdentifier>>(){

            @Override
            public Token<TimelineDelegationTokenIdentifier> run() throws Exception {
                DelegationTokenAuthenticatedURL authUrl = TimelineClientImpl.this.connector.getDelegationTokenAuthenticatedURL();
                return authUrl.getDelegationToken(TimelineConnector.constructResURI(TimelineClientImpl.this.getConfig(), TimelineClientImpl.this.getTimelineServiceAddress(), TimelineClientImpl.RESOURCE_URI_STR_V1).toURL(), TimelineClientImpl.this.token, renewer, TimelineClientImpl.this.doAsUser);
            }
        };
        return (Token)this.connector.operateDelegationToken(getDTAction);
    }

    @Override
    public long renewDelegationToken(final Token<TimelineDelegationTokenIdentifier> timelineDT) throws IOException, YarnException {
        final boolean isTokenServiceAddrEmpty = timelineDT.getService().toString().isEmpty();
        final String scheme = isTokenServiceAddrEmpty ? null : (YarnConfiguration.useHttps((Configuration)this.getConfig()) ? "https" : "http");
        final InetSocketAddress address = isTokenServiceAddrEmpty ? null : SecurityUtil.getTokenServiceAddr(timelineDT);
        PrivilegedExceptionAction<Long> renewDTAction = new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws Exception {
                if (!timelineDT.equals((Object)TimelineClientImpl.this.token.getDelegationToken())) {
                    TimelineClientImpl.this.token.setDelegationToken(timelineDT);
                }
                DelegationTokenAuthenticatedURL authUrl = TimelineClientImpl.this.connector.getDelegationTokenAuthenticatedURL();
                URI serviceURI = isTokenServiceAddrEmpty ? TimelineConnector.constructResURI(TimelineClientImpl.this.getConfig(), TimelineClientImpl.this.getTimelineServiceAddress(), TimelineClientImpl.RESOURCE_URI_STR_V1) : new URI(scheme, null, address.getHostName(), address.getPort(), TimelineClientImpl.RESOURCE_URI_STR_V1, null, null);
                return authUrl.renewDelegationToken(serviceURI.toURL(), TimelineClientImpl.this.token, TimelineClientImpl.this.doAsUser);
            }
        };
        return (Long)this.connector.operateDelegationToken(renewDTAction);
    }

    @Override
    public void cancelDelegationToken(final Token<TimelineDelegationTokenIdentifier> timelineDT) throws IOException, YarnException {
        final boolean isTokenServiceAddrEmpty = timelineDT.getService().toString().isEmpty();
        final String scheme = isTokenServiceAddrEmpty ? null : (YarnConfiguration.useHttps((Configuration)this.getConfig()) ? "https" : "http");
        final InetSocketAddress address = isTokenServiceAddrEmpty ? null : SecurityUtil.getTokenServiceAddr(timelineDT);
        PrivilegedExceptionAction<Void> cancelDTAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                if (!timelineDT.equals((Object)TimelineClientImpl.this.token.getDelegationToken())) {
                    TimelineClientImpl.this.token.setDelegationToken(timelineDT);
                }
                DelegationTokenAuthenticatedURL authUrl = TimelineClientImpl.this.connector.getDelegationTokenAuthenticatedURL();
                URI serviceURI = isTokenServiceAddrEmpty ? TimelineConnector.constructResURI(TimelineClientImpl.this.getConfig(), TimelineClientImpl.this.getTimelineServiceAddress(), TimelineClientImpl.RESOURCE_URI_STR_V1) : new URI(scheme, null, address.getHostName(), address.getPort(), TimelineClientImpl.RESOURCE_URI_STR_V1, null, null);
                authUrl.cancelDelegationToken(serviceURI.toURL(), TimelineClientImpl.this.token, TimelineClientImpl.this.doAsUser);
                return null;
            }
        };
        this.connector.operateDelegationToken(cancelDTAction);
    }

    public String toString() {
        return super.toString() + " with timeline server " + TimelineConnector.constructResURI(this.getConfig(), this.getTimelineServiceAddress(), RESOURCE_URI_STR_V1) + " and writer " + this.timelineWriter;
    }

    public static void main(String[] argv) throws Exception {
        String path;
        CommandLine cliParser = new GnuParser().parse(opts, argv);
        if (cliParser.hasOption("put") && (path = cliParser.getOptionValue("put")) != null && path.length() > 0) {
            if (cliParser.hasOption(ENTITY_DATA_TYPE)) {
                TimelineClientImpl.putTimelineDataInJSONFile(path, ENTITY_DATA_TYPE);
                return;
            }
            if (cliParser.hasOption(DOMAIN_DATA_TYPE)) {
                TimelineClientImpl.putTimelineDataInJSONFile(path, DOMAIN_DATA_TYPE);
                return;
            }
        }
        TimelineClientImpl.printUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putTimelineDataInJSONFile(String path, String type) {
        File jsonFile = new File(path);
        if (!jsonFile.exists()) {
            LOG.error((Object)("File [" + jsonFile.getAbsolutePath() + "] doesn't exist"));
            return;
        }
        YarnJacksonJaxbJsonProvider.configObjectMapper(MAPPER);
        TimelineEntities entities = null;
        TimelineDomains domains = null;
        try {
            if (type.equals(ENTITY_DATA_TYPE)) {
                entities = (TimelineEntities)MAPPER.readValue(jsonFile, TimelineEntities.class);
            } else if (type.equals(DOMAIN_DATA_TYPE)) {
                domains = (TimelineDomains)MAPPER.readValue(jsonFile, TimelineDomains.class);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error when reading  " + e.getMessage()));
            e.printStackTrace(System.err);
            return;
        }
        YarnConfiguration conf = new YarnConfiguration();
        TimelineClient client = TimelineClient.createTimelineClient();
        client.init((Configuration)conf);
        client.start();
        try {
            if (UserGroupInformation.isSecurityEnabled() && conf.getBoolean("yarn.timeline-service.enabled", false)) {
                Token<TimelineDelegationTokenIdentifier> token = client.getDelegationToken(UserGroupInformation.getCurrentUser().getUserName());
                UserGroupInformation.getCurrentUser().addToken(token);
            }
            if (type.equals(ENTITY_DATA_TYPE)) {
                TimelinePutResponse response = client.putEntities(entities.getEntities().toArray(new TimelineEntity[entities.getEntities().size()]));
                if (response.getErrors().size() == 0) {
                    LOG.info((Object)"Timeline entities are successfully put");
                } else {
                    for (TimelinePutResponse.TimelinePutError error : response.getErrors()) {
                        LOG.error((Object)("TimelineEntity [" + error.getEntityType() + ":" + error.getEntityId() + "] is not successfully put. Error code: " + error.getErrorCode()));
                    }
                }
            } else if (type.equals(DOMAIN_DATA_TYPE) && domains != null) {
                boolean hasError = false;
                for (TimelineDomain domain : domains.getDomains()) {
                    try {
                        client.putDomain(domain);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error when putting domain " + domain.getId()), (Throwable)e);
                        hasError = true;
                    }
                }
                if (!hasError) {
                    LOG.info((Object)"Timeline domains are successfully put");
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error when putting the timeline data", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when putting the timeline data", (Throwable)e);
        }
        finally {
            client.stop();
        }
    }

    private static void printUsage() {
        new HelpFormatter().printHelp("TimelineClient", opts);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public UserGroupInformation getUgi() {
        return this.authUgi;
    }

    @Override
    public TimelinePutResponse putEntities(ApplicationAttemptId appAttemptId, TimelineEntityGroupId groupId, TimelineEntity ... entities) throws IOException, YarnException {
        if (!this.timelineServiceV15Enabled) {
            throw new YarnException("This API is not supported under current Timeline Service Version:");
        }
        return this.timelineWriter.putEntities(appAttemptId, groupId, entities);
    }

    @Override
    public void putDomain(ApplicationAttemptId appAttemptId, TimelineDomain domain) throws IOException, YarnException {
        if (!this.timelineServiceV15Enabled) {
            throw new YarnException("This API is not supported under current Timeline Service Version:");
        }
        this.timelineWriter.putDomain(appAttemptId, domain);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setTimelineWriter(TimelineWriter writer) {
        this.timelineWriter = writer;
    }

    static {
        opts.addOption("put", true, "Put the timeline entities/domain in a JSON file");
        opts.getOption("put").setArgName("Path to the JSON file");
        opts.addOption(ENTITY_DATA_TYPE, false, "Specify the JSON file contains the entities");
        opts.addOption(DOMAIN_DATA_TYPE, false, "Specify the JSON file contains the domain");
        opts.addOption("help", false, "Print usage");
    }
}

