/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.event;

import com.qcloud.cos.event.COSProgressListener;
import com.qcloud.cos.event.DeliveryMode;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.transfer.PersistableTransfer;
import java.util.concurrent.Future;
import org.slf4j.LoggerFactory;

public class COSProgressPublisher
extends SDKProgressPublisher {
    public static Future<?> publishTransferPersistable(ProgressListener listener, PersistableTransfer persistableTransfer) {
        if (persistableTransfer == null || !(listener instanceof COSProgressListener)) {
            return null;
        }
        COSProgressListener coslistener = (COSProgressListener)listener;
        return COSProgressPublisher.deliverEvent(coslistener, persistableTransfer);
    }

    private static Future<?> deliverEvent(final COSProgressListener listener, final PersistableTransfer persistableTransfer) {
        DeliveryMode mode;
        if (listener instanceof DeliveryMode && (mode = (DeliveryMode)((Object)listener)).isSyncCallSafe()) {
            return COSProgressPublisher.quietlyCallListener(listener, persistableTransfer);
        }
        return COSProgressPublisher.setLatestFutureTask(COSProgressPublisher.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                listener.onPersistableTransfer(persistableTransfer);
            }
        }));
    }

    private static Future<?> quietlyCallListener(COSProgressListener listener, PersistableTransfer persistableTransfer) {
        try {
            listener.onPersistableTransfer(persistableTransfer);
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(COSProgressPublisher.class).debug("Failure from the event listener", t);
        }
        return null;
    }
}

