/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLUnpivot
extends SQLObjectImpl {
    protected NullsIncludeType nullsIncludeType;
    protected List<SQLExpr> items = new ArrayList<SQLExpr>();
    protected final List<SQLExpr> pivotFor = new ArrayList<SQLExpr>();
    protected final List<SQLSelectItem> pivotIn = new ArrayList<SQLSelectItem>();

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v, this.items);
            this.acceptChild(v, this.pivotFor);
            this.acceptChild(v, this.pivotIn);
        }
        v.endVisit(this);
    }

    public NullsIncludeType getNullsIncludeType() {
        return this.nullsIncludeType;
    }

    public void setNullsIncludeType(NullsIncludeType nullsIncludeType) {
        this.nullsIncludeType = nullsIncludeType;
    }

    public List<SQLExpr> getPivotFor() {
        return this.pivotFor;
    }

    public List<SQLSelectItem> getPivotIn() {
        return this.pivotIn;
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public void addItem(SQLExpr item) {
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    @Override
    public SQLUnpivot clone() {
        SQLObject e2;
        SQLUnpivot x = new SQLUnpivot();
        x.setNullsIncludeType(this.nullsIncludeType);
        for (SQLExpr sQLExpr : this.items) {
            e2 = sQLExpr.clone();
            e2.setParent(x);
            x.getItems().add((SQLExpr)e2);
        }
        for (SQLExpr sQLExpr : this.pivotFor) {
            e2 = sQLExpr.clone();
            e2.setParent(x);
            x.getPivotFor().add((SQLExpr)e2);
        }
        for (SQLSelectItem sQLSelectItem : this.pivotIn) {
            e2 = sQLSelectItem.clone();
            ((SQLObjectImpl)e2).setParent(x);
            x.getPivotIn().add((SQLSelectItem)e2);
        }
        return x;
    }

    public static enum NullsIncludeType {
        INCLUDE_NULLS,
        EXCLUDE_NULLS;


        public static String toString(NullsIncludeType type, boolean ucase) {
            if (INCLUDE_NULLS.equals((Object)type)) {
                return ucase ? "INCLUDE NULLS" : "include nulls";
            }
            if (EXCLUDE_NULLS.equals((Object)type)) {
                return ucase ? "EXCLUDE NULLS" : "exclude nulls";
            }
            throw new IllegalArgumentException();
        }
    }
}

