/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.server.master.cluster.AbstractClusterSubscribeListener;
import org.apache.dolphinscheduler.server.master.cluster.BaseServerMetadata;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;
import org.apache.dolphinscheduler.server.master.cluster.WorkerGroupChangeNotifier;
import org.apache.dolphinscheduler.server.master.cluster.WorkerServerMetadata;

public class WorkerClusters
extends AbstractClusterSubscribeListener<WorkerServerMetadata>
implements IClusters<WorkerServerMetadata>,
WorkerGroupChangeNotifier.WorkerGroupListener {
    private final Map<String, WorkerServerMetadata> workerMapping = new ConcurrentHashMap<String, WorkerServerMetadata>();
    private final Map<String, List<String>> dbWorkerGroupMapping = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> configWorkerGroupMapping = new ConcurrentHashMap<String, List<String>>();
    private final List<IClusters.IClustersChangeListener<WorkerServerMetadata>> workerClusterChangeListeners = new CopyOnWriteArrayList<IClusters.IClustersChangeListener<WorkerServerMetadata>>();

    @Override
    public List<WorkerServerMetadata> getServers() {
        return UnmodifiableList.unmodifiableList(new ArrayList<WorkerServerMetadata>(this.workerMapping.values()));
    }

    @Override
    public Optional<WorkerServerMetadata> getServer(String address) {
        return Optional.ofNullable(this.workerMapping.get(address));
    }

    public List<String> getDbWorkerServerAddressByGroup(String workerGroup) {
        if (WorkerGroupUtils.getDefaultWorkerGroup().equals(workerGroup)) {
            return UnmodifiableList.unmodifiableList(new ArrayList<String>(this.workerMapping.keySet()));
        }
        return this.dbWorkerGroupMapping.getOrDefault(workerGroup, Collections.emptyList());
    }

    public List<String> getConfigWorkerServerAddressByGroup(String workerGroup) {
        if (WorkerGroupUtils.getDefaultWorkerGroup().equals(workerGroup)) {
            return UnmodifiableList.unmodifiableList(new ArrayList<String>(this.workerMapping.keySet()));
        }
        return this.configWorkerGroupMapping.getOrDefault(workerGroup, Collections.emptyList());
    }

    public List<String> getNormalWorkerServerAddressByGroup(String workerGroup) {
        List dbWorkerAddresses = this.getDbWorkerServerAddressByGroup(workerGroup).stream().map(this.workerMapping::get).filter(Objects::nonNull).filter(workerServer -> workerServer.getServerStatus() == ServerStatus.NORMAL).map(BaseServerMetadata::getAddress).collect(Collectors.toList());
        List configWorkerAddresses = this.getConfigWorkerServerAddressByGroup(workerGroup).stream().map(this.workerMapping::get).filter(Objects::nonNull).filter(workerServer -> workerServer.getServerStatus() == ServerStatus.NORMAL).map(BaseServerMetadata::getAddress).collect(Collectors.toList());
        dbWorkerAddresses.removeAll(configWorkerAddresses);
        dbWorkerAddresses.addAll(configWorkerAddresses);
        return UnmodifiableList.unmodifiableList(dbWorkerAddresses);
    }

    public boolean containsWorkerGroup(String workerGroup) {
        return WorkerGroupUtils.getDefaultWorkerGroup().equals(workerGroup) || this.dbWorkerGroupMapping.containsKey(workerGroup) || this.configWorkerGroupMapping.containsKey(workerGroup);
    }

    @Override
    public void registerListener(IClusters.IClustersChangeListener<WorkerServerMetadata> listener) {
        this.workerClusterChangeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWorkerGroupDelete(List<WorkerGroup> workerGroups) {
        Map<String, List<String>> map = this.dbWorkerGroupMapping;
        synchronized (map) {
            for (WorkerGroup workerGroup : workerGroups) {
                this.dbWorkerGroupMapping.remove(workerGroup.getName());
            }
        }
    }

    @Override
    public void onWorkerGroupAdd(List<WorkerGroup> workerGroups) {
        this.onWorkerGroupChange(workerGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWorkerGroupChange(List<WorkerGroup> workerGroups) {
        for (WorkerGroup workerGroup : workerGroups) {
            List workerAddresses = WorkerGroupUtils.getWorkerAddressListFromWorkerGroup((WorkerGroup)workerGroup);
            Map<String, List<String>> map = this.dbWorkerGroupMapping;
            synchronized (map) {
                this.dbWorkerGroupMapping.put(workerGroup.getName(), workerAddresses);
            }
        }
    }

    @Override
    WorkerServerMetadata parseServerFromHeartbeat(String serverHeartBeatJson) {
        WorkerHeartBeat workerHeartBeat = (WorkerHeartBeat)JSONUtils.parseObject((String)serverHeartBeatJson, WorkerHeartBeat.class);
        if (workerHeartBeat == null) {
            return null;
        }
        return WorkerServerMetadata.parseFromHeartBeat(workerHeartBeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerAdded(WorkerServerMetadata workerServer) {
        this.workerMapping.put(workerServer.getAddress(), workerServer);
        Map<String, List<String>> map = this.configWorkerGroupMapping;
        synchronized (map) {
            List<String> list = this.configWorkerGroupMapping.get(workerServer.getWorkerGroup());
            if (list == null) {
                ArrayList<String> newWorkerGroupAddrList = new ArrayList<String>();
                newWorkerGroupAddrList.add(workerServer.getAddress());
                this.configWorkerGroupMapping.put(workerServer.getWorkerGroup(), newWorkerGroupAddrList);
            } else if (!list.contains(workerServer.getAddress())) {
                list.add(workerServer.getAddress());
                this.configWorkerGroupMapping.put(workerServer.getWorkerGroup(), list);
            }
        }
        for (IClusters.IClustersChangeListener iClustersChangeListener : this.workerClusterChangeListeners) {
            iClustersChangeListener.onServerAdded(workerServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerRemove(WorkerServerMetadata workerServer) {
        this.workerMapping.remove(workerServer.getAddress(), workerServer);
        Map<String, List<String>> map = this.configWorkerGroupMapping;
        synchronized (map) {
            List<String> list = this.configWorkerGroupMapping.get(workerServer.getWorkerGroup());
            if (list != null && list.contains(workerServer.getAddress())) {
                list.remove(workerServer.getAddress());
                if (list.isEmpty()) {
                    this.configWorkerGroupMapping.remove(workerServer.getWorkerGroup());
                }
            }
        }
        for (IClusters.IClustersChangeListener iClustersChangeListener : this.workerClusterChangeListeners) {
            iClustersChangeListener.onServerRemove(workerServer);
        }
    }

    @Override
    public void onServerUpdate(WorkerServerMetadata workerServer) {
        this.workerMapping.put(workerServer.getAddress(), workerServer);
        for (IClusters.IClustersChangeListener<WorkerServerMetadata> listener : this.workerClusterChangeListeners) {
            listener.onServerUpdate(workerServer);
        }
    }
}

