/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.workqueue.ratelimiter;

import io.kubernetes.client.extended.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class ItemExponentialFailureRateLimiter<T>
implements RateLimiter<T> {
    private Duration baseDelay;
    private Duration maxDelay;
    private ConcurrentMap<T, AtomicLong> failures = new ConcurrentHashMap<T, AtomicLong>();

    public ItemExponentialFailureRateLimiter(Duration baseDelay, Duration maxDelay) {
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public Duration when(T item) {
        long exp = this.failures.computeIfAbsent(item, k -> new AtomicLong()).getAndIncrement();
        long d = this.maxDelay.toMillis() >> (int)exp;
        return d > this.baseDelay.toMillis() ? this.baseDelay.multipliedBy(1 << (int)exp) : this.maxDelay;
    }

    @Override
    public void forget(T item) {
        this.failures.remove(item);
    }

    @Override
    public int numRequeues(T item) {
        return (int)this.failures.computeIfAbsent(item, k -> new AtomicLong()).get();
    }
}

