/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.HttpProtocolTypeEnum;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import shade.okhttp3.Authenticator;
import shade.okhttp3.ConnectionPool;
import shade.okhttp3.Credentials;
import shade.okhttp3.Dispatcher;
import shade.okhttp3.Dns;
import shade.okhttp3.OkHttpClient;
import shade.okhttp3.Protocol;
import shade.okhttp3.Request;
import shade.okhttp3.Response;
import shade.okhttp3.Route;

public class RestUtils {
    private static final ILogger log = LoggerBuilder.getLogger(RestUtils.class);
    private static final Set<Character> SPECIAL_CHAR = new HashSet<Character>();
    private static Pattern chinesePattern;
    private static final X509TrustManager TRUST_ALL_MANAGER;

    public static String uriEncode(CharSequence input, boolean chineseOnly) throws ServiceException {
        StringBuilder result = new StringBuilder();
        try {
            RestUtils.tryEncode(input, chineseOnly, result);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to encode input: " + input);
        }
        return result.toString();
    }

    private static void tryEncode(CharSequence input, boolean chineseOnly, StringBuilder result) throws UnsupportedEncodingException {
        if (chineseOnly) {
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                String s = Character.toString(ch);
                Matcher m = chinesePattern.matcher(s);
                if (m != null && m.find()) {
                    result.append(URLEncoder.encode(s, "UTF-8"));
                    continue;
                }
                result.append(ch);
            }
        } else {
            for (int i = 0; i < input.length(); ++i) {
                boolean isNumber;
                char ch = input.charAt(i);
                boolean isAlpha = ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
                boolean bl = isNumber = ch >= '0' && ch <= '9';
                if (isAlpha || isNumber || SPECIAL_CHAR.contains(Character.valueOf(ch))) {
                    result.append(ch);
                    continue;
                }
                if (ch == '/') {
                    result.append("%2F");
                    continue;
                }
                result.append(URLEncoder.encode(Character.toString(ch), "UTF-8"));
            }
        }
    }

    public static String encodeUrlString(String path) throws ServiceException {
        try {
            return URLEncoder.encode(path, "UTF-8").replaceAll("\\+", "%20").replaceAll("%7E", "~").replaceAll("\\*", "%2A");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServiceException("Unable to encode path: " + path, uee);
        }
    }

    public static String encodeUrlPath(String path, String delimiter) throws ServiceException {
        StringBuilder result = new StringBuilder();
        String[] tokens = path.split(delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            result.append(RestUtils.encodeUrlString(tokens[i]));
            if (i >= tokens.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    private static SSLContext createSSLContext(KeyManager[] km, TrustManager[] tm, String provider, SecureRandom secureRandom) throws Exception {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2", provider);
        }
        catch (Exception e) {
            try {
                sslContext = SSLContext.getInstance("TLSv1.1", provider);
            }
            catch (Exception ex) {
                try {
                    sslContext = SSLContext.getInstance("TLSv1.0", provider);
                }
                catch (Exception exx) {
                    sslContext = SSLContext.getInstance("TLS", provider);
                }
            }
        }
        sslContext.init(km, tm, secureRandom);
        return sslContext;
    }

    private static SSLContext createSSLContext(KeyManager[] km, TrustManager[] tm, SecureRandom secureRandom) throws Exception {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
        }
        catch (Exception e) {
            try {
                sslContext = SSLContext.getInstance("TLSv1.1");
            }
            catch (Exception ex) {
                try {
                    sslContext = SSLContext.getInstance("TLSv1.0");
                }
                catch (Exception exx) {
                    sslContext = SSLContext.getInstance("TLS");
                }
            }
        }
        sslContext.init(km, tm, secureRandom);
        return sslContext;
    }

    public static OkHttpClient.Builder initHttpClientBuilder(ObsProperties obsProperties, KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, Dispatcher httpDispatcher, SecureRandom secureRandom) {
        OkHttpClient.Builder builder;
        block11: {
            ArrayList<Protocol> protocols = new ArrayList<Protocol>(2);
            protocols.add(Protocol.HTTP_1_1);
            if (HttpProtocolTypeEnum.getValueFromCode(obsProperties.getStringProperty("httpclient.protocol", HttpProtocolTypeEnum.HTTP1_1.getCode())) == HttpProtocolTypeEnum.HTTP2_0) {
                protocols.add(Protocol.HTTP_2);
            }
            builder = new OkHttpClient.Builder();
            RestUtils.initHttpDispatcher(obsProperties, httpDispatcher, builder);
            ConnectionPool pool = new ConnectionPool(obsProperties.getIntProperty("httpclient.max-idle-connections", 1000), obsProperties.getIntProperty("httpclient.idle-connection-time", 30000), TimeUnit.MILLISECONDS);
            builder.protocols(protocols).followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(obsProperties.getBoolProperty("httpclient.is-retry-on-connection-failure-in-okhttp", false)).cache(null).connectTimeout(obsProperties.getIntProperty("httpclient.connection-timeout-ms", 20000), TimeUnit.MILLISECONDS).writeTimeout(obsProperties.getIntProperty("httpclient.socket-timeout-ms", 60000), TimeUnit.MILLISECONDS).readTimeout(obsProperties.getIntProperty("httpclient.socket-timeout-ms", 60000), TimeUnit.MILLISECONDS).connectionPool(pool).hostnameVerifier((hostname, session) -> !obsProperties.getBoolProperty("httpclient.strict-hostname-verification", false) || HttpsURLConnection.getDefaultHostnameVerifier().verify(obsProperties.getStringProperty("obs-endpoint", ""), session)).dns(hostname -> {
                List<InetAddress> adds = Dns.SYSTEM.lookup(hostname);
                log.info("internet host address:" + adds);
                return adds;
            });
            int socketReadBufferSize = obsProperties.getIntProperty("socket.read-buffer-size", -1);
            int socketWriteBufferSize = obsProperties.getIntProperty("socket.write-buffer-size", -1);
            int socketReadWriteBufferSize = Math.max(socketReadBufferSize, socketWriteBufferSize);
            builder.socketFactory(new WrapperedSocketFactory(SocketFactory.getDefault(), socketReadWriteBufferSize));
            try {
                SSLContext sslContext;
                X509TrustManager trustManager;
                TrustManager[] tm;
                KeyManager[] km;
                block10: {
                    km = null;
                    if (obsProperties.getBoolProperty("httpclient.validate-certificate", false)) {
                        KeyManager[] keyManagerArray = km = keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers();
                        if (trustManagerFactory == null || trustManagerFactory.getTrustManagers().length < 1) {
                            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            trustManagerFactory.init((KeyStore)null);
                        }
                        tm = trustManagerFactory.getTrustManagers();
                        trustManager = (X509TrustManager)tm[0];
                    } else {
                        trustManager = TRUST_ALL_MANAGER;
                        tm = new TrustManager[]{trustManager};
                    }
                    String provider = obsProperties.getStringProperty("httpclient.ssl-provider", "");
                    sslContext = null;
                    if (ServiceUtils.isValid(provider)) {
                        try {
                            sslContext = RestUtils.createSSLContext(km, tm, provider, secureRandom);
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block10;
                            log.error("Exception happened in create ssl context with provider" + provider, e);
                        }
                    }
                }
                if (sslContext == null) {
                    sslContext = RestUtils.createSSLContext(km, tm, secureRandom);
                }
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(new WrapperedSSLSocketFactory(sslSocketFactory, socketReadWriteBufferSize), trustManager);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block11;
                log.error("Exception happened in HttpClient.configSSL,and e = " + e);
            }
        }
        return builder;
    }

    private static void initHttpDispatcher(ObsProperties obsProperties, Dispatcher httpDispatcher, OkHttpClient.Builder builder) {
        if (httpDispatcher == null) {
            int maxConnections = obsProperties.getIntProperty("httpclient.max-connections", 1000);
            httpDispatcher = new Dispatcher();
            httpDispatcher.setMaxRequests(maxConnections);
            httpDispatcher.setMaxRequestsPerHost(maxConnections);
            builder.dispatcher(httpDispatcher);
        } else {
            try {
                Method m = builder.getClass().getMethod("dispatcher", httpDispatcher.getClass());
                m.invoke((Object)builder, httpDispatcher);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn("invoke " + httpDispatcher.getClass() + ".dispatcher() failed.", e);
                }
                try {
                    Class<?> c = Class.forName("shade.okhttp3.AbsDispatcher");
                    Method m = builder.getClass().getMethod("dispatcher", c);
                    m.invoke((Object)builder, httpDispatcher);
                }
                catch (Exception ex) {
                    throw new ObsException("invoke okhttp3.AbsDispatcher.dispatcher failed", ex);
                }
            }
        }
    }

    public static void initHttpProxy(OkHttpClient.Builder builder, String proxyHostAddress, int proxyPort, final String proxyUser, final String proxyPassword) {
        if (proxyHostAddress != null && proxyPort != -1) {
            if (log.isInfoEnabled()) {
                log.info("Using Proxy: " + proxyHostAddress + ":" + proxyPort);
            }
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostAddress, proxyPort)));
            if (proxyUser != null && !proxyUser.trim().equals("")) {
                Authenticator proxyAuthenticator = new Authenticator(){

                    @Override
                    public Request authenticate(Route route, Response response) throws IOException {
                        String credential = Credentials.basic(proxyUser, proxyPassword);
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
                builder.proxyAuthenticator(proxyAuthenticator);
            }
        }
    }

    public static String readBodyFromResponse(Response response) {
        String body;
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return body;
    }

    static {
        SPECIAL_CHAR.add(Character.valueOf('_'));
        SPECIAL_CHAR.add(Character.valueOf('-'));
        SPECIAL_CHAR.add(Character.valueOf('~'));
        SPECIAL_CHAR.add(Character.valueOf('.'));
        chinesePattern = Pattern.compile("[\u4e00-\u9fa5]");
        TRUST_ALL_MANAGER = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        };
    }

    private static class WrapperedSSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory delegate;
        private int socketReadWriteBufferSize;

        WrapperedSSLSocketFactory(SSLSocketFactory delegate, int socketReadWriteBufferSize) {
            this.delegate = delegate;
            this.socketReadWriteBufferSize = socketReadWriteBufferSize;
        }

        private Socket doWrap(Socket s) throws SocketException {
            if (s != null) {
                if (this.socketReadWriteBufferSize > 0) {
                    s.setReceiveBufferSize(this.socketReadWriteBufferSize);
                    s.setReceiveBufferSize(this.socketReadWriteBufferSize);
                }
                s.setTcpNoDelay(true);
            }
            return s;
        }

        @Override
        public Socket createSocket() throws IOException, UnknownHostException {
            return this.doWrap(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.doWrap(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.doWrap(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.doWrap(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.doWrap(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.doWrap(this.delegate.createSocket(address, port, localAddress, localPort));
        }
    }

    private static class WrapperedSocketFactory
    extends SocketFactory {
        private SocketFactory delegate;
        private int socketReadWriteBufferSize;

        WrapperedSocketFactory(SocketFactory delegate, int socketReadWriteBufferSize) {
            this.delegate = delegate;
            this.socketReadWriteBufferSize = socketReadWriteBufferSize;
        }

        private Socket doWrap(Socket s) throws SocketException {
            if (s != null) {
                if (this.socketReadWriteBufferSize > 0) {
                    s.setReceiveBufferSize(this.socketReadWriteBufferSize);
                    s.setReceiveBufferSize(this.socketReadWriteBufferSize);
                }
                s.setTcpNoDelay(true);
            }
            return s;
        }

        @Override
        public Socket createSocket() throws IOException, UnknownHostException {
            return this.doWrap(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.doWrap(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.doWrap(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.doWrap(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.doWrap(this.delegate.createSocket(address, port, localAddress, localPort));
        }
    }
}

