/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.RenameFileDto;
import org.apache.dolphinscheduler.api.dto.resources.RenameFileRequest;
import org.apache.dolphinscheduler.api.validator.ITransformer;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RenameFileRequestTransformer
implements ITransformer<RenameFileRequest, RenameFileDto> {
    @Autowired
    private StorageOperator storageOperator;

    @Override
    public RenameFileDto transform(RenameFileRequest renameFileRequest) {
        ResourceMetadata resourceMetaData = this.storageOperator.getResourceMetaData(renameFileRequest.getFileAbsolutePath());
        return RenameFileDto.builder().loginUser(renameFileRequest.getLoginUser()).originFileAbsolutePath(renameFileRequest.getFileAbsolutePath()).targetFileAbsolutePath(FileUtils.concatFilePath((String[])new String[]{resourceMetaData.getResourceParentAbsolutePath(), renameFileRequest.getNewFileName()})).build();
    }
}

