/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class WeekYearTest
extends AbstractLangTest {
    WeekYearTest() {
    }

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{new GregorianCalendar(2005, 0, 1), "2004-W53-6"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2005, 0, 2), "2004-W53-7"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2005, 11, 31), "2005-W52-6"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2007, 0, 1), "2007-W01-1"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2007, 11, 30), "2007-W52-7"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2007, 11, 31), "2008-W01-1"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2008, 0, 1), "2008-W01-2"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2008, 11, 28), "2008-W52-7"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2008, 11, 29), "2009-W01-1"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2008, 11, 30), "2009-W01-2"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2008, 11, 31), "2009-W01-3"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2009, 0, 1), "2009-W01-4"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2009, 11, 31), "2009-W53-4"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2010, 0, 1), "2009-W53-5"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2010, 0, 2), "2009-W53-6"}), Arguments.of((Object[])new Object[]{new GregorianCalendar(2010, 0, 3), "2009-W53-7"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testParser(Calendar vulgar, String isoForm) {
        FastDateParser parser = new FastDateParser("YYYY-'W'ww-u", TimeZone.getDefault(), Locale.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.setMinimalDaysInFirstWeek(4);
        cal.setFirstDayOfWeek(2);
        cal.clear();
        parser.parse(isoForm, new ParsePosition(0), cal);
        Assertions.assertEquals((Object)vulgar.getTime(), (Object)cal.getTime());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testPrinter(Calendar vulgar, String isoForm) {
        FastDatePrinter printer = new FastDatePrinter("YYYY-'W'ww-u", TimeZone.getDefault(), Locale.getDefault());
        vulgar.setMinimalDaysInFirstWeek(4);
        vulgar.setFirstDayOfWeek(2);
        Assertions.assertEquals((Object)isoForm, (Object)printer.format(vulgar));
    }
}

