/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SystemUtilsTest
extends AbstractLangTest {
    SystemUtilsTest() {
    }

    private boolean getIS_JAVA(int version) throws Exception {
        return SystemUtils.class.getField("IS_JAVA_" + version).getBoolean(null);
    }

    public int getLastSupportedJavaVersion() {
        int lastSupportedVersion = 0;
        for (Field field : SystemUtils.class.getFields()) {
            if (!field.getName().matches("IS_JAVA_\\d+")) continue;
            lastSupportedVersion = Math.max(lastSupportedVersion, Integer.parseInt(field.getName().substring(8)));
        }
        return lastSupportedVersion;
    }

    @Test
    void test_IS_JAVA() throws Exception {
        String javaVersion = SystemUtils.JAVA_VERSION;
        int lastSupportedVersion = this.getLastSupportedJavaVersion();
        if (javaVersion == null) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_14);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_15);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_16);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_17);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_18);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_19);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_20);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_21);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_22);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_23);
            for (int version = 9; version <= lastSupportedVersion; ++version) {
                Assertions.assertFalse((boolean)this.getIS_JAVA(version));
            }
        } else if (javaVersion.startsWith("1.8")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertTrue((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_10);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_11);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_12);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_13);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_14);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_15);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_16);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_17);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_18);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_19);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_20);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_21);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_22);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_23);
            for (int version = 9; version <= lastSupportedVersion; ++version) {
                Assertions.assertFalse((boolean)this.getIS_JAVA(version));
            }
        } else if (!javaVersion.startsWith("1.")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assertions.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assertions.assertEquals((Object)javaVersion.startsWith("9"), (Object)SystemUtils.IS_JAVA_1_9);
            for (int version = 9; version <= lastSupportedVersion; ++version) {
                Assertions.assertEquals((Object)javaVersion.startsWith("" + version), (Object)this.getIS_JAVA(version));
            }
        } else {
            System.out.println("Can't test IS_JAVA value: " + javaVersion);
        }
    }

    @Test
    void test_IS_OS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_SOLARIS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_LINUX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_MAC_OSX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else if (osName.startsWith("Windows")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ANDROID);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else if (osName.startsWith("Solaris")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_SOLARIS);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ANDROID);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else if (osName.toLowerCase(Locale.ENGLISH).startsWith("linux")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_LINUX);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else if (osName.startsWith("Mac OS X")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_MAC_OSX);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ANDROID);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
            boolean[] macOsValues = new boolean[]{SystemUtils.IS_OS_MAC_OSX_BIG_SUR, SystemUtils.IS_OS_MAC_OSX_CATALINA, SystemUtils.IS_OS_MAC_OSX_CHEETAH, SystemUtils.IS_OS_MAC_OSX_EL_CAPITAN, SystemUtils.IS_OS_MAC_OSX_HIGH_SIERRA, SystemUtils.IS_OS_MAC_OSX_JAGUAR, SystemUtils.IS_OS_MAC_OSX_LEOPARD, SystemUtils.IS_OS_MAC_OSX_LION, SystemUtils.IS_OS_MAC_OSX_MAVERICKS, SystemUtils.IS_OS_MAC_OSX_MOJAVE, SystemUtils.IS_OS_MAC_OSX_MONTEREY, SystemUtils.IS_OS_MAC_OSX_MOUNTAIN_LION, SystemUtils.IS_OS_MAC_OSX_PANTHER, SystemUtils.IS_OS_MAC_OSX_PUMA, SystemUtils.IS_OS_MAC_OSX_SEQUOIA, SystemUtils.IS_OS_MAC_OSX_SIERRA, SystemUtils.IS_OS_MAC_OSX_SNOW_LEOPARD, SystemUtils.IS_OS_MAC_OSX_SONOMA, SystemUtils.IS_OS_MAC_OSX_TIGER, SystemUtils.IS_OS_MAC_OSX_VENTURA, SystemUtils.IS_OS_MAC_OSX_YOSEMITE};
            if (BooleanUtils.or((boolean[])macOsValues)) {
                Assertions.assertTrue((boolean)BooleanUtils.xor((boolean[])macOsValues));
            }
        } else if (osName.startsWith("OS/2")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_OS2);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ANDROID);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else if (osName.startsWith("SunOS")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_SUN_OS);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ANDROID);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else if (osName.startsWith("FreeBSD")) {
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_FREE_BSD);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ANDROID);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_NETWARE);
        } else {
            System.err.println("Can't test IS_OS_ value: " + osName);
        }
    }

    @Test
    void test_IS_zOS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_ZOS);
        } else if (osName.contains("z/OS")) {
            Assertions.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assertions.assertTrue((boolean)SystemUtils.IS_OS_ZOS);
        }
    }

    @Test
    void test_USER_NAME() {
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)SystemUtils.USER_NAME);
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new SystemUtils());
        Constructor<?>[] cons = SystemUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(SystemUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(SystemUtils.class.getModifiers()));
    }

    @Test
    void testGetEnvironmentVariableAbsent() {
        String name = "THIS_ENV_VAR_SHOULD_NOT_EXIST_FOR_THIS_TEST_TO_PASS";
        String expected = System.getenv("THIS_ENV_VAR_SHOULD_NOT_EXIST_FOR_THIS_TEST_TO_PASS");
        Assertions.assertNull((Object)expected);
        String value = SystemUtils.getEnvironmentVariable((String)"THIS_ENV_VAR_SHOULD_NOT_EXIST_FOR_THIS_TEST_TO_PASS", (String)"DEFAULT");
        Assertions.assertEquals((Object)"DEFAULT", (Object)value);
    }

    @Test
    void testGetEnvironmentVariablePresent() {
        String name = "PATH";
        String expected = System.getenv("PATH");
        String value = SystemUtils.getEnvironmentVariable((String)"PATH", null);
        Assertions.assertEquals((Object)expected, (Object)value);
    }

    @Test
    void testGetHostName() {
        String hostName = SystemUtils.getHostName();
        String expected = SystemUtils.IS_OS_WINDOWS ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        Assertions.assertEquals((Object)expected, (Object)hostName);
    }

    @Test
    void testGetJavaHome() {
        File dir = SystemUtils.getJavaHome();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    void testGetJavaHomePath() {
        Path dir = SystemUtils.getJavaHomePath();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)Files.exists(dir, new LinkOption[0]));
    }

    @Test
    void testGetJavaIoTmpDir() {
        File dir = SystemUtils.getJavaIoTmpDir();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    void testGetJavaIoTmpDirPath() {
        Path dir = SystemUtils.getJavaIoTmpDirPath();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)Files.exists(dir, new LinkOption[0]));
    }

    @Test
    void testGetUserDir() {
        File dir = SystemUtils.getUserDir();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    void testGetUserDirPath() {
        Path dir = SystemUtils.getUserDirPath();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)Files.exists(dir, new LinkOption[0]));
    }

    @Test
    void testGetUserHome() {
        File dir = SystemUtils.getUserHome();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)dir.exists());
    }

    @Test
    void testGetUserHomePath() {
        Path dir = SystemUtils.getUserHomePath();
        Assertions.assertNotNull((Object)dir);
        Assertions.assertTrue((boolean)Files.exists(dir, new LinkOption[0]));
    }

    @Test
    void testGetUserName() {
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)SystemUtils.getUserName());
        Assertions.assertEquals((Object)System.getProperty("user.name", "foo"), (Object)SystemUtils.getUserName((String)"foo"));
    }

    @Test
    void testIsJavaVersionAtLeast() {
        if (SystemUtils.IS_JAVA_1_8) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_9) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_10) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_11) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_12) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_13) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
        } else if (SystemUtils.IS_JAVA_14) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_15) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_16) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_17) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_18) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_19) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_20) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_21) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_22) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_23) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_24) {
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_24));
        }
    }

    @Test
    void testIsJavaVersionAtMost() {
        if (SystemUtils.IS_JAVA_1_8) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_9) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_10) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_11) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_12) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_13) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_14) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_15) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_16) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_17) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_18) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_19) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_20) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_21) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_22) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_23) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        } else if (SystemUtils.IS_JAVA_24) {
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_1));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_2));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_3));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_4));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_5));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_6));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_7));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_1_8));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_9));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_10));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_11));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_12));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_13));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_14));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_15));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_16));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_18));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_19));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_21));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_22));
            Assertions.assertFalse((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_23));
            Assertions.assertTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_24));
        }
    }

    @Test
    void testJavaAwtHeadless() {
        String expectedStringValue = System.getProperty("java.awt.headless");
        String expectedStringValueWithDefault = System.getProperty("java.awt.headless", "false");
        Assertions.assertNotNull((Object)expectedStringValueWithDefault);
        boolean expectedValue = Boolean.parseBoolean(expectedStringValue);
        if (expectedStringValue != null) {
            Assertions.assertEquals((Object)expectedStringValue, (Object)SystemUtils.JAVA_AWT_HEADLESS);
        }
        Assertions.assertEquals((Object)expectedValue, (Object)SystemUtils.isJavaAwtHeadless());
        Assertions.assertEquals((Object)expectedStringValueWithDefault, (Object)("" + SystemUtils.isJavaAwtHeadless()));
    }

    @Test
    void testJavaVersionMatches() {
        String javaVersion = null;
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"24"));
        javaVersion = "";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.0";
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.1";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.2";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.3.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.3.1";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.4.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.4.1";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.4.2";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.5.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.6.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.7.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "1.8.0";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "9";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "10";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "11";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "17";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "21";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "22";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "23";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
        javaVersion = "24";
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"10"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"11"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"12"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"13"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"14"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"15"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"16"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"17"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"18"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"19"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"20"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"21"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"22"));
        Assertions.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"23"));
        Assertions.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"24"));
    }

    @Test
    void testOSMatchesName() {
        String osName = null;
        Assertions.assertFalse((boolean)SystemUtils.isOsNameMatch(osName, (String)"Windows"));
        osName = "";
        Assertions.assertFalse((boolean)SystemUtils.isOsNameMatch((String)osName, (String)"Windows"));
        osName = "Windows 95";
        Assertions.assertTrue((boolean)SystemUtils.isOsNameMatch((String)osName, (String)"Windows"));
        osName = "Windows NT";
        Assertions.assertTrue((boolean)SystemUtils.isOsNameMatch((String)osName, (String)"Windows"));
        osName = "OS/2";
        Assertions.assertFalse((boolean)SystemUtils.isOsNameMatch((String)osName, (String)"Windows"));
    }

    @Test
    void testOSMatchesNameAndVersion() {
        String osName = null;
        String osVersion = null;
        Assertions.assertFalse((boolean)SystemUtils.isOsMatch(osName, osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "";
        osVersion = "";
        Assertions.assertFalse((boolean)SystemUtils.isOsMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.0";
        Assertions.assertFalse((boolean)SystemUtils.isOsMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.1";
        Assertions.assertTrue((boolean)SystemUtils.isOsMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 98";
        osVersion = "4.1";
        Assertions.assertTrue((boolean)SystemUtils.isOsMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows NT";
        osVersion = "4.0";
        Assertions.assertFalse((boolean)SystemUtils.isOsMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "OS/2";
        osVersion = "4.0";
        Assertions.assertFalse((boolean)SystemUtils.isOsMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
    }

    @Test
    void testOsVersionMatches() {
        String osVersion = null;
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch(osVersion, (String)"10.1"));
        osVersion = "";
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1"));
        osVersion = "10";
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.1";
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.1.1";
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.10";
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.10.1";
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1"));
        Assertions.assertFalse((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.1.1"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10"));
        Assertions.assertTrue((boolean)SystemUtils.isOsVersionMatch((String)osVersion, (String)"10.10.1"));
    }
}

