/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtilsTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringUtilsIsTest
extends AbstractLangTest {
    StringUtilsIsTest() {
    }

    @Test
    void testIsAlpha() {
        Assertions.assertFalse((boolean)StringUtils.isAlpha(null));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isAlpha((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.isAlpha((CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.isAlpha((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"ham kso"));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"1"));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"_"));
        Assertions.assertFalse((boolean)StringUtils.isAlpha((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    void testIsAlphanumeric() {
        Assertions.assertFalse((boolean)StringUtils.isAlphanumeric(null));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)"ham kso"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"1"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumeric((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)"_"));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumeric((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    void testIsAlphanumericSpace() {
        Assertions.assertFalse((boolean)StringUtils.isAlphanumericSpace(null));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"ham kso"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"1"));
        Assertions.assertTrue((boolean)StringUtils.isAlphanumericSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumericSpace((CharSequence)"_"));
        Assertions.assertFalse((boolean)StringUtils.isAlphanumericSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    void testIsAlphaspace() {
        Assertions.assertFalse((boolean)StringUtils.isAlphaSpace(null));
        Assertions.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assertions.assertTrue((boolean)StringUtils.isAlphaSpace((CharSequence)"ham kso"));
        Assertions.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"1"));
        Assertions.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assertions.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"_"));
        Assertions.assertFalse((boolean)StringUtils.isAlphaSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    void testIsAsciiPrintable_String() {
        Assertions.assertFalse((boolean)StringUtils.isAsciiPrintable(null));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"A"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"1"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"Ceki"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"!ab2c~"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"1000"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"10 00"));
        Assertions.assertFalse((boolean)StringUtils.isAsciiPrintable((CharSequence)"10\t00"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"10.00"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"10,00"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"!ab-c~"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"hkHK=Hik6i?UGH_KJgU7.tUJgKJ*GI87GI,kug"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"!"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"~"));
        Assertions.assertFalse((boolean)StringUtils.isAsciiPrintable((CharSequence)"\u007f"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"G?lc?"));
        Assertions.assertTrue((boolean)StringUtils.isAsciiPrintable((CharSequence)"=?iso-8859-1?Q?G=FClc=FC?="));
        Assertions.assertFalse((boolean)StringUtils.isAsciiPrintable((CharSequence)"G\u00fclc\u00fc"));
    }

    @Test
    void testIsNumeric() {
        Assertions.assertFalse((boolean)StringUtils.isNumeric(null));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)" "));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"a"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"A"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"ham kso"));
        Assertions.assertTrue((boolean)StringUtils.isNumeric((CharSequence)"1"));
        Assertions.assertTrue((boolean)StringUtils.isNumeric((CharSequence)"1000"));
        Assertions.assertTrue((boolean)StringUtils.isNumeric((CharSequence)"\u0967\u0968\u0969"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"\u0967\u0968 \u0969"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"2.3"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"10 00"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"_"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"hkHKHik*khbkuh"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"+123"));
        Assertions.assertFalse((boolean)StringUtils.isNumeric((CharSequence)"-123"));
    }

    @Test
    void testIsNumericSpace() {
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace(null));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)" "));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"a"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"A"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"kgKgKgKgkgkGkjkjlJlOKLgHdGdHgl"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"ham kso"));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"1"));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"1000"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"2.3"));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"10 00"));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"\u0967\u0968\u0969"));
        Assertions.assertTrue((boolean)StringUtils.isNumericSpace((CharSequence)"\u0967\u0968 \u0969"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"hkHKHik6iUGHKJgU7tUJgKJGI87GIkug"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"_"));
        Assertions.assertFalse((boolean)StringUtils.isNumericSpace((CharSequence)"hkHKHik*khbkuh"));
    }

    @Test
    void testIsWhitespace() {
        Assertions.assertFalse((boolean)StringUtils.isWhitespace(null));
        Assertions.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)""));
        Assertions.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)" "));
        Assertions.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)"\t \n \t"));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"\t aa\n \t"));
        Assertions.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)" "));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)" a "));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"a  "));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"  a"));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"aba"));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)"a"));
        Assertions.assertTrue((boolean)StringUtils.isWhitespace((CharSequence)StringUtilsTest.WHITESPACE));
        Assertions.assertFalse((boolean)StringUtils.isWhitespace((CharSequence)StringUtilsTest.NON_WHITESPACE));
    }
}

