/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeLiteralTest
extends AbstractLangTest {
    TypeLiteralTest() {
    }

    @Test
    void testBasic() {
        Assertions.assertTrue((boolean)TypeUtils.equals(String.class, (Type)new TypeLiteral<String>(){}.value));
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{String.class}), (Type)new TypeLiteral<List<String>>(){}.value));
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new TypeLiteral<String>(){}, (Object)new TypeLiteral<String>(){});
        Assertions.assertEquals((Object)new TypeLiteral<List<String>>(){}, (Object)new TypeLiteral<List<String>>(){});
        Assertions.assertNotEquals((Object)new TypeLiteral<String>(){}, (Object)new TypeLiteral<List<String>>(){});
    }

    @Test
    void testRaw() {
        LangAssertions.assertNullPointerException(() -> new TypeLiteral(){});
    }

    @Test
    void testTyped() {
        TypeLiteral<String> stringType = new TypeLiteral<String>(){};
        Assertions.assertTrue((boolean)TypeUtils.equals(String.class, (Type)stringType.getType()));
        TypeLiteral<List<String>> listOfStringType = new TypeLiteral<List<String>>(){};
        Assertions.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{String.class}), (Type)listOfStringType.getType()));
    }
}

