/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Duration;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPoolingDriver
extends TestConnectionPool {
    private PoolingDriver driver;

    @Override
    protected Connection getConnection() throws Exception {
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
    }

    @BeforeEach
    public void setUp() throws Exception {
        DriverConnectionFactory cf = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", null);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, null);
        pcf.setPoolStatements(true);
        pcf.setMaxOpenPreparedStatements(10);
        pcf.setValidationQuery("SELECT COUNT(*) FROM DUAL");
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(this.getMaxTotal());
        poolConfig.setMaxWait(this.getMaxWaitDuration());
        poolConfig.setMinIdle(10);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(10000L));
        poolConfig.setNumTestsPerEvictionRun(5);
        poolConfig.setMinEvictableIdleTime(Duration.ofMillis(5000L));
        GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)pcf, poolConfig);
        pcf.setPool((ObjectPool)pool);
        Assertions.assertNotNull((Object)pcf);
        this.driver = new PoolingDriver(true);
        this.driver.registerPool("test", (ObjectPool)pool);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.driver.closePool("test");
        super.tearDown();
    }

    @Test
    void test1() {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:some:connect:string", "userName", "password");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf);
        pcf.setPool((ObjectPool)connectionPool);
        PoolingDataSource ds = new PoolingDataSource((ObjectPool)connectionPool);
        Assertions.assertNotNull((Object)ds);
    }

    @Test
    void test2() {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:some:connect:string", "userName", "password");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pcf);
        PoolingDriver driver2 = new PoolingDriver();
        driver2.registerPool("example", (ObjectPool)connectionPool);
    }

    @Test
    void testClosePool() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
        Assertions.assertNotNull((Object)conn);
        conn.close();
        PoolingDriver driver2 = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver2.closePool("test");
        Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection("jdbc:apache:commons:dbcp:test"));
    }

    @Test
    void testInvalidateConnection() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:apache:commons:dbcp:test");
        Assertions.assertNotNull((Object)conn);
        ObjectPool pool = this.driver.getConnectionPool("test");
        Assertions.assertEquals((int)1, (int)pool.getNumActive());
        Assertions.assertEquals((int)0, (int)pool.getNumIdle());
        PoolingDriver driver2 = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver2.invalidateConnection(conn);
        Assertions.assertEquals((int)0, (int)pool.getNumActive());
        Assertions.assertTrue((boolean)conn.isClosed());
    }

    @Test
    void testLogWriter() throws Exception {
        PrintStream ps = new PrintStream((OutputStream)new ByteArrayOutputStream(), false, StandardCharsets.UTF_8.name());
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), StandardCharsets.UTF_8));
        System.setErr(new PrintStream((OutputStream)new ByteArrayOutputStream(), false, StandardCharsets.UTF_8.name()));
        DriverManager.setLogWriter(pw);
        SQLException ex = new SQLException("A", new Exception("a"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException("B");
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException(null, new Exception("c"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException((String)null);
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        DriverManager.setLogWriter(null);
        ex = new SQLException("A", new Exception("a"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException("B");
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException(null, new Exception("c"));
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
        ex = new SQLException((String)null);
        ex.printStackTrace();
        ex.printStackTrace(ps);
        ex.printStackTrace(pw);
    }

    @Test
    void testReportedBug12400() throws Exception {
        int i;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(70);
        config.setMaxWait(Duration.ofMinutes(1L));
        config.setMaxIdle(10);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "userName", "password");
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        poolableConnectionFactory.setDefaultReadOnly(Boolean.FALSE);
        poolableConnectionFactory.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, config);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        Assertions.assertNotNull((Object)poolableConnectionFactory);
        PoolingDriver driver2 = new PoolingDriver();
        driver2.registerPool("neusoftim", (ObjectPool)connectionPool);
        Connection[] conn = new Connection[25];
        for (i = 0; i < 25; ++i) {
            conn[i] = DriverManager.getConnection("jdbc:apache:commons:dbcp:neusoftim");
            for (int j = 0; j < i; ++j) {
                Assertions.assertNotSame((Object)conn[j], (Object)conn[i]);
                Assertions.assertNotEquals((Object)conn[j], (Object)conn[i]);
            }
        }
        for (i = 0; i < 25; ++i) {
            conn[i].close();
        }
    }

    @Test
    void testReportedBug28912() throws Exception {
        Connection conn1 = this.getConnection();
        Assertions.assertNotNull((Object)conn1);
        Assertions.assertFalse((boolean)conn1.isClosed());
        conn1.close();
        Connection conn2 = this.getConnection();
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertTrue((boolean)conn1.isClosed());
        Assertions.assertFalse((boolean)conn2.isClosed());
        conn1.close();
        Assertions.assertTrue((boolean)conn1.isClosed());
        Assertions.assertFalse((boolean)conn2.isClosed());
    }
}

