/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Convert speech audio to text using IBM Watson Speech to Text
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WatsonSpeechToTextEndpointBuilderFactory {

    /**
     * Builder for endpoint for the IBM Watson Speech to Text component.
     */
    public interface WatsonSpeechToTextEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWatsonSpeechToTextEndpointBuilder advanced() {
            return (AdvancedWatsonSpeechToTextEndpointBuilder) this;
        }

        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * The audio format (MIME type). Default is audio/wav. Supported
         * formats: audio/wav, audio/mp3, audio/flac, audio/ogg, audio/webm.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: audio/wav
         * Group: producer
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * The language model to use for recognition. Default is
         * en-US_BroadbandModel. Examples: en-US_NarrowbandModel,
         * en-GB_BroadbandModel, es-ES_BroadbandModel, fr-FR_BroadbandModel.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: en-US_BroadbandModel
         * Group: producer
         * 
         * @param model the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder model(String model) {
            doSetProperty("model", model);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.watson.stt.WatsonSpeechToTextOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder operation(org.apache.camel.component.ibm.watson.stt.WatsonSpeechToTextOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.watson.stt.WatsonSpeechToTextOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Whether to identify different speakers in the audio. Default is
         * false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param speakerLabels the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder speakerLabels(boolean speakerLabels) {
            doSetProperty("speakerLabels", speakerLabels);
            return this;
        }
        /**
         * Whether to identify different speakers in the audio. Default is
         * false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param speakerLabels the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder speakerLabels(String speakerLabels) {
            doSetProperty("speakerLabels", speakerLabels);
            return this;
        }
        /**
         * Whether to include timestamps for each word in the transcription.
         * Default is false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param timestamps the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder timestamps(boolean timestamps) {
            doSetProperty("timestamps", timestamps);
            return this;
        }
        /**
         * Whether to include timestamps for each word in the transcription.
         * Default is false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param timestamps the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder timestamps(String timestamps) {
            doSetProperty("timestamps", timestamps);
            return this;
        }
        /**
         * Whether to include confidence scores for each word. Default is false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param wordConfidence the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder wordConfidence(boolean wordConfidence) {
            doSetProperty("wordConfidence", wordConfidence);
            return this;
        }
        /**
         * Whether to include confidence scores for each word. Default is false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param wordConfidence the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder wordConfidence(String wordConfidence) {
            doSetProperty("wordConfidence", wordConfidence);
            return this;
        }
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM Watson Speech to Text component.
     */
    public interface AdvancedWatsonSpeechToTextEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WatsonSpeechToTextEndpointBuilder basic() {
            return (WatsonSpeechToTextEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonSpeechToTextEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonSpeechToTextEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface WatsonSpeechToTextBuilders {
        /**
         * IBM Watson Speech to Text (camel-ibm-watson-speech-to-text)
         * Convert speech audio to text using IBM Watson Speech to Text
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-ibm-watson-speech-to-text
         * 
         * @return the dsl builder for the headers' name.
         */
        default WatsonSpeechToTextHeaderNameBuilder ibmWatsonSpeechToText() {
            return WatsonSpeechToTextHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM Watson Speech to Text (camel-ibm-watson-speech-to-text)
         * Convert speech audio to text using IBM Watson Speech to Text
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-ibm-watson-speech-to-text
         * 
         * Syntax: <code>ibm-watson-speech-to-text:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder ibmWatsonSpeechToText(String path) {
            return WatsonSpeechToTextEndpointBuilderFactory.endpointBuilder("ibm-watson-speech-to-text", path);
        }
        /**
         * IBM Watson Speech to Text (camel-ibm-watson-speech-to-text)
         * Convert speech audio to text using IBM Watson Speech to Text
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-ibm-watson-speech-to-text
         * 
         * Syntax: <code>ibm-watson-speech-to-text:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default WatsonSpeechToTextEndpointBuilder ibmWatsonSpeechToText(String componentName, String path) {
            return WatsonSpeechToTextEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM Watson Speech to Text component.
     */
    public static class WatsonSpeechToTextHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WatsonSpeechToTextHeaderNameBuilder INSTANCE = new WatsonSpeechToTextHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTOperation}.
         */
        public String iBMWatsonSTTOperation() {
            return "CamelIBMWatsonSTTOperation";
        }
        /**
         * The audio file to transcribe.
         * 
         * The option is a: {@code java.io.File} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTAudioFile}.
         */
        public String iBMWatsonSTTAudioFile() {
            return "CamelIBMWatsonSTTAudioFile";
        }
        /**
         * The language model to use for recognition.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTModel}.
         */
        public String iBMWatsonSTTModel() {
            return "CamelIBMWatsonSTTModel";
        }
        /**
         * The audio format (e.g., audio/wav, audio/mp3, audio/flac).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTContentType}.
         */
        public String iBMWatsonSTTContentType() {
            return "CamelIBMWatsonSTTContentType";
        }
        /**
         * Whether to include timestamps in the transcription.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTTimestamps}.
         */
        public String iBMWatsonSTTTimestamps() {
            return "CamelIBMWatsonSTTTimestamps";
        }
        /**
         * Whether to include word confidence scores.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTWordConfidence}.
         */
        public String iBMWatsonSTTWordConfidence() {
            return "CamelIBMWatsonSTTWordConfidence";
        }
        /**
         * Whether to identify different speakers.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTSpeakerLabels}.
         */
        public String iBMWatsonSTTSpeakerLabels() {
            return "CamelIBMWatsonSTTSpeakerLabels";
        }
        /**
         * The name of the model to retrieve.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTModelName}.
         */
        public String iBMWatsonSTTModelName() {
            return "CamelIBMWatsonSTTModelName";
        }
        /**
         * The language for filtering models.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTLanguage}.
         */
        public String iBMWatsonSTTLanguage() {
            return "CamelIBMWatsonSTTLanguage";
        }
        /**
         * The transcription result text.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonSTTTranscript}.
         */
        public String iBMWatsonSTTTranscript() {
            return "CamelIBMWatsonSTTTranscript";
        }
    }
    static WatsonSpeechToTextEndpointBuilder endpointBuilder(String componentName, String path) {
        class WatsonSpeechToTextEndpointBuilderImpl extends AbstractEndpointBuilder implements WatsonSpeechToTextEndpointBuilder, AdvancedWatsonSpeechToTextEndpointBuilder {
            public WatsonSpeechToTextEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WatsonSpeechToTextEndpointBuilderImpl(path);
    }
}