<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Apache Parquet Geometry/Geography Rust Implementation Details

[![crates.io](https://img.shields.io/crates/v/parquet-geospatial.svg)](https://crates.io/crates/parquet-geospatial)
[![docs.rs](https://img.shields.io/docsrs/parquet-geospatial.svg)](https://docs.rs/parquet/latest/parquet-geospatial/)

This crate contains implementation details for the [Geometry and Geography Encoding] from
[Apache Parquet], including utilities for calculating geospatial column statistics and writing
tests. This software is developed as part of the [Apache Arrow] project.

[Geometry and Geography Encoding]: https://github.com/apache/parquet-format/blob/master/Geospatial.md
[Apache Parquet]: https://parquet.apache.org/
[Apache Arrow]: https://arrow.apache.org/

Please see the [API documentation](https://docs.rs/parquet-geospatial/latest) for more details.

## License

Licensed under the Apache License, Version 2.0: <http://www.apache.org/licenses/LICENSE-2.0>.
