#! /bin/sh
# Copyright (C) 2001-2020 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Make sure that config* files are properly regenerated.

. test-init.sh

echo "FOO = foo" > Makefile.am

$ACLOCAL

echo "$me: Generated by aclocal ..."
$AUTOMAKE
grep '^\$(ACLOCAL_M4):' Makefile.in

echo "$me: Not generated by aclocal ..."
# Pretend it is not from aclocal (remove the signature),
# but keep it correct, i.e., with AM_INIT_AUTOMAKE etc.
sed -n '3,$p' aclocal.m4 >aclocal.m4t
mv -f aclocal.m4t aclocal.m4
$AUTOMAKE
grep '^\$(ACLOCAL_M4):' Makefile.in && exit 1

:
