package Daje::Document::Builder;
use Mojo::Base -base;
use v5.42;


# NAME
# ====
#
#      Daje::Document::Builder - It's the document builder
#
# Synopsis
# ========
#
#     my $error = Daje::Workflow::Errors::Error->new()
#
#     my $builder = Daje::Document::Builder->new(
#         source        => 'Template class',
#         data_sections => 'sections',
#         data          => $data,
#         error         => $error
#     );
#
#     $builder->process();
#
#     if($builder->error->has_error()) {
#         say $builder->error->error()
#     } else {
#         my $documents = $builder->output();
#     }
#
#
#
#
# REQUIRES
# ========
#
# use Mojo::Base;
# use Template;
#
# DESCRIPTION
# ===========
#
# Daje::Document::Builder Builds documents based on Template Toolkit
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#

use Template;
use Mojo::Loader qw {load_class};
use Class::Load qw(is_class_loaded);
use Daje::Document::Load::Template;
use Data::Dumper;

our $VERSION = "0.15";

has 'data';
has 'source';
has 'template';
has 'data_sections';
has 'error';
has 'output';

sub process($self) {
    my $templates = Daje::Document::Load::Template->new(
        source        => $self->source(),
        error         => $self->error(),
        data_sections => $self->data_sections(),
    );
    $templates->load_templates();

    unless ($templates->error->has_error()) {
        try {
            my $documents;
            $self->_prepare_data();
            my $tt = Template->new();
            my @data_sec = split(',', $self->data_sections) ;
            my $length = scalar @data_sec;
            for (my $i = 0; $i < $length; $i++) {
                my $output = "";
                $tt->process(\$templates->{template}->{data_sec}->{$data_sec[$i]}, $self->data(), \$output);
                say $tt->error if $tt->error();
                $self->error->add_error($tt->error) if (defined $tt->error);
                my $section->{name} = $data_sec[$i];
                $section->{document} = $output;
                push @{$documents}, $section;
            }
            $self->error->add_error($tt->error) if (defined $tt->error);
            say $tt->error if (defined $tt->error);
            $self->output($documents);
        } catch($e) {
            say $e;
            $self->error->add_error($e);
        }
    } else {
        $self->error->add_error($templates->error->error());
    }
    return 1;
}

sub _prepare_data($self) {
    if(!is_class_loaded($self->source())) {
        my $c = load_class($self->source());
    }
    my $temp = $self->source()->new()->add_subs($self->data);
}

1;
__END__



#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


     Daje::Document::Builder - It's the document builder



=head1 DESCRIPTION


Daje::Document::Builder Builds documents based on Template Toolkit



=head1 REQUIRES


use Mojo::Base;
use Template;



=head1 METHODS

=head2 process($self)

 process($self)();


=head1 Synopsis


    my $error = Daje::Workflow::Errors::Error->new()

    my $builder = Daje::Document::Builder->new(
        source        => 'Template class',
        data_sections => 'sections',
        data          => $data,
        error         => $error
    );

    $builder->process();

    if($builder->error->has_error()) {
        say $builder->error->error()
    } else {
        my $documents = $builder->output();
    }






=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

